"""Seeded RNG used only for tie resolution (PF/Born)."""
from __future__ import annotations
import numpy as np

class RNG:
    def __init__(self, seed: int, family: str = "pcg64"):
        if family != "pcg64":
            raise ValueError("Only pcg64 is supported in this minimal build.")
        self._rg = np.random.Generator(np.random.PCG64(seed))

    def choice(self, probs):
        probs = np.asarray(probs, dtype=float)
        probs = probs / probs.sum()
        return int(self._rg.choice(len(probs), p=probs))

    def uniform(self, a=0.0, b=1.0):
        return float(self._rg.uniform(a, b))

    def integers(self, low: int, high: int | None = None):
        return int(self._rg.integers(low, high))
